/*
 * Decompiled with CFR 0.152.
 */
package com.ms.studio.models;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RSS2 {
    private String title;
    private String link;
    private String description;
    private String logo;
    private String language;
    private String webMaster;
    private String copyright;
    private Integer ttl;
    private List<Item> items;
    private Follow follow;

    public String toXmlString() {
        Document document = DocumentHelper.createDocument();
        Element root = DocumentHelper.createElement("rss");
        root.addAttribute("version", "2.0");
        document.setRootElement(root);
        Element channel = root.addElement("channel");
        channel.addElement("title").addText(this.title);
        channel.addElement("link").addText(this.link);
        channel.addElement("description").addText(this.description);
        if (StringUtils.isNotBlank((CharSequence)this.logo)) {
            Element image = channel.addElement("image");
            image.addElement("url").addText(this.logo);
            image.addElement("title").addText(this.title);
            image.addElement("link").addText(this.link);
        }
        channel.addElement("ttl").addText(String.valueOf(this.ttl));
        channel.addElement("language").addText(this.language);
        if (StringUtils.isNotBlank((CharSequence)this.webMaster)) {
            channel.addElement("webMaster").addText(this.webMaster);
        }
        channel.addElement("copyright").addText("Copyright \u00a9 " + Instant.now().atOffset(ZoneOffset.UTC).getYear() + " " + this.copyright);
        channel.addElement("pubDate").addText(Instant.now().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME));
        if (this.items != null && this.items.size() > 1) {
            channel.addElement("lastBuildDate").addText(this.items.get(1).getPubDate().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME));
        }
        if (this.items != null) {
            this.items.forEach(item -> {
                Element itemElement = channel.addElement("item");
                itemElement.addElement("title").addCDATA(item.getTitle());
                itemElement.addElement("link").addText(item.getLink());
                itemElement.addElement("description").addCDATA(item.getDescription());
                itemElement.addElement("author").addText(item.getAuthor());
                itemElement.addElement("guid").addText(item.getGuid());
                itemElement.addElement("pubDate").addText(item.pubDate.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME));
                if (item.getCategories() != null) {
                    item.getCategories().forEach(category -> itemElement.addElement("category").addText((String)category));
                }
            });
        }
        if (this.follow != null && StringUtils.isNotBlank((CharSequence)this.follow.getFeedId()) && StringUtils.isNotBlank((CharSequence)this.follow.getUserId())) {
            Element followElement = channel.addElement("follow_challenge");
            followElement.addElement("feedId").addText(this.follow.getFeedId());
            followElement.addElement("userId").addText(this.follow.getUserId());
        }
        return document.asXML();
    }

    RSS2(String title, String link, String description, String logo, String language, String webMaster, String copyright, Integer ttl, List<Item> items, Follow follow) {
        this.title = title;
        this.link = link;
        this.description = description;
        this.logo = logo;
        this.language = language;
        this.webMaster = webMaster;
        this.copyright = copyright;
        this.ttl = ttl;
        this.items = items;
        this.follow = follow;
    }

    public static RSS2Builder builder() {
        return new RSS2Builder();
    }

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getWebMaster() {
        return this.webMaster;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Follow getFollow() {
        return this.follow;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setWebMaster(String webMaster) {
        this.webMaster = webMaster;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public void setFollow(Follow follow) {
        this.follow = follow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RSS2)) {
            return false;
        }
        RSS2 other = (RSS2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$webMaster = this.getWebMaster();
        String other$webMaster = other.getWebMaster();
        if (this$webMaster == null ? other$webMaster != null : !this$webMaster.equals(other$webMaster)) {
            return false;
        }
        String this$copyright = this.getCopyright();
        String other$copyright = other.getCopyright();
        if (this$copyright == null ? other$copyright != null : !this$copyright.equals(other$copyright)) {
            return false;
        }
        List<Item> this$items = this.getItems();
        List<Item> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Follow this$follow = this.getFollow();
        Follow other$follow = other.getFollow();
        return !(this$follow == null ? other$follow != null : !((Object)this$follow).equals(other$follow));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RSS2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $webMaster = this.getWebMaster();
        result = result * 59 + ($webMaster == null ? 43 : $webMaster.hashCode());
        String $copyright = this.getCopyright();
        result = result * 59 + ($copyright == null ? 43 : $copyright.hashCode());
        List<Item> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Follow $follow = this.getFollow();
        result = result * 59 + ($follow == null ? 43 : ((Object)$follow).hashCode());
        return result;
    }

    public String toString() {
        return "RSS2(title=" + this.getTitle() + ", link=" + this.getLink() + ", description=" + this.getDescription() + ", logo=" + this.getLogo() + ", language=" + this.getLanguage() + ", webMaster=" + this.getWebMaster() + ", copyright=" + this.getCopyright() + ", ttl=" + this.getTtl() + ", items=" + this.getItems() + ", follow=" + this.getFollow() + ")";
    }

    public static class Item {
        private String title;
        private String link;
        private String description;
        private String author;
        private Instant pubDate;
        private String guid;
        private List<String> categories;

        Item(String title, String link, String description, String author, Instant pubDate, String guid, List<String> categories) {
            this.title = title;
            this.link = link;
            this.description = description;
            this.author = author;
            this.pubDate = pubDate;
            this.guid = guid;
            this.categories = categories;
        }

        public static ItemBuilder builder() {
            return new ItemBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public String getLink() {
            return this.link;
        }

        public String getDescription() {
            return this.description;
        }

        public String getAuthor() {
            return this.author;
        }

        public Instant getPubDate() {
            return this.pubDate;
        }

        public String getGuid() {
            return this.guid;
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setPubDate(Instant pubDate) {
            this.pubDate = pubDate;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public void setCategories(List<String> categories) {
            this.categories = categories;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$link = this.getLink();
            String other$link = other.getLink();
            if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            Instant this$pubDate = this.getPubDate();
            Instant other$pubDate = other.getPubDate();
            if (this$pubDate == null ? other$pubDate != null : !((Object)this$pubDate).equals(other$pubDate)) {
                return false;
            }
            String this$guid = this.getGuid();
            String other$guid = other.getGuid();
            if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) {
                return false;
            }
            List<String> this$categories = this.getCategories();
            List<String> other$categories = other.getCategories();
            return !(this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : $link.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            Instant $pubDate = this.getPubDate();
            result = result * 59 + ($pubDate == null ? 43 : ((Object)$pubDate).hashCode());
            String $guid = this.getGuid();
            result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
            List<String> $categories = this.getCategories();
            result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
            return result;
        }

        public String toString() {
            return "RSS2.Item(title=" + this.getTitle() + ", link=" + this.getLink() + ", description=" + this.getDescription() + ", author=" + this.getAuthor() + ", pubDate=" + this.getPubDate() + ", guid=" + this.getGuid() + ", categories=" + this.getCategories() + ")";
        }

        public static class ItemBuilder {
            private String title;
            private String link;
            private String description;
            private String author;
            private Instant pubDate;
            private String guid;
            private List<String> categories;

            ItemBuilder() {
            }

            public ItemBuilder title(String title) {
                this.title = title;
                return this;
            }

            public ItemBuilder link(String link) {
                this.link = link;
                return this;
            }

            public ItemBuilder description(String description) {
                this.description = description;
                return this;
            }

            public ItemBuilder author(String author) {
                this.author = author;
                return this;
            }

            public ItemBuilder pubDate(Instant pubDate) {
                this.pubDate = pubDate;
                return this;
            }

            public ItemBuilder guid(String guid) {
                this.guid = guid;
                return this;
            }

            public ItemBuilder categories(List<String> categories) {
                this.categories = categories;
                return this;
            }

            public Item build() {
                return new Item(this.title, this.link, this.description, this.author, this.pubDate, this.guid, this.categories);
            }

            public String toString() {
                return "RSS2.Item.ItemBuilder(title=" + this.title + ", link=" + this.link + ", description=" + this.description + ", author=" + this.author + ", pubDate=" + this.pubDate + ", guid=" + this.guid + ", categories=" + this.categories + ")";
            }
        }
    }

    public static class Follow {
        private String feedId;
        private String userId;

        Follow(String feedId, String userId) {
            this.feedId = feedId;
            this.userId = userId;
        }

        public static FollowBuilder builder() {
            return new FollowBuilder();
        }

        public String getFeedId() {
            return this.feedId;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setFeedId(String feedId) {
            this.feedId = feedId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Follow)) {
                return false;
            }
            Follow other = (Follow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$feedId = this.getFeedId();
            String other$feedId = other.getFeedId();
            if (this$feedId == null ? other$feedId != null : !this$feedId.equals(other$feedId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Follow;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $feedId = this.getFeedId();
            result = result * 59 + ($feedId == null ? 43 : $feedId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        public String toString() {
            return "RSS2.Follow(feedId=" + this.getFeedId() + ", userId=" + this.getUserId() + ")";
        }

        public static class FollowBuilder {
            private String feedId;
            private String userId;

            FollowBuilder() {
            }

            public FollowBuilder feedId(String feedId) {
                this.feedId = feedId;
                return this;
            }

            public FollowBuilder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public Follow build() {
                return new Follow(this.feedId, this.userId);
            }

            public String toString() {
                return "RSS2.Follow.FollowBuilder(feedId=" + this.feedId + ", userId=" + this.userId + ")";
            }
        }
    }

    public static class RSS2Builder {
        private String title;
        private String link;
        private String description;
        private String logo;
        private String language;
        private String webMaster;
        private String copyright;
        private Integer ttl;
        private List<Item> items;
        private Follow follow;

        RSS2Builder() {
        }

        public RSS2Builder title(String title) {
            this.title = title;
            return this;
        }

        public RSS2Builder link(String link) {
            this.link = link;
            return this;
        }

        public RSS2Builder description(String description) {
            this.description = description;
            return this;
        }

        public RSS2Builder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public RSS2Builder language(String language) {
            this.language = language;
            return this;
        }

        public RSS2Builder webMaster(String webMaster) {
            this.webMaster = webMaster;
            return this;
        }

        public RSS2Builder copyright(String copyright) {
            this.copyright = copyright;
            return this;
        }

        public RSS2Builder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public RSS2Builder items(List<Item> items) {
            this.items = items;
            return this;
        }

        public RSS2Builder follow(Follow follow) {
            this.follow = follow;
            return this;
        }

        public RSS2 build() {
            return new RSS2(this.title, this.link, this.description, this.logo, this.language, this.webMaster, this.copyright, this.ttl, this.items, this.follow);
        }

        public String toString() {
            return "RSS2.RSS2Builder(title=" + this.title + ", link=" + this.link + ", description=" + this.description + ", logo=" + this.logo + ", language=" + this.language + ", webMaster=" + this.webMaster + ", copyright=" + this.copyright + ", ttl=" + this.ttl + ", items=" + this.items + ", follow=" + this.follow + ")";
        }
    }
}

