/*
 * Decompiled with CFR 0.152.
 */
package com.ms.studio.service.impl;

import com.ms.studio.enums.BasicConfig;
import com.ms.studio.enums.FollowConfig;
import com.ms.studio.enums.RssConfig;
import com.ms.studio.models.ContentWrapper;
import com.ms.studio.models.RSS2;
import com.ms.studio.service.RssService;
import com.ms.studio.service.RssSourceFinder;
import com.ms.studio.utils.ReactiveSettingFetcherUtils;
import com.ms.studio.utils.XmlCharUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import run.halo.app.core.extension.content.Post;
import run.halo.app.extension.ListResult;
import run.halo.app.infra.ExternalUrlSupplier;
import run.halo.app.infra.SystemSetting;

@Service
public class RssServiceImpl
implements RssService {
    private static final Logger log = LoggerFactory.getLogger(RssServiceImpl.class);
    private static final int FIRST_PAGE = 1;
    private final ReactiveSettingFetcherUtils settingFetcher;
    private final ExternalUrlSupplier externalUrlSupplier;
    private final RssSourceFinder rssSourceFinder;

    @Override
    public Mono<ServerResponse> allRss(ServerRequest request) {
        return this.getFeedContext(request).flatMap(feedContext -> {
            RSS2 rss2 = this.buildBaseRss((FeedContext)feedContext);
            return this.postListResultToXmlServerResponse(this.rssSourceFinder.listPosts(1, feedContext.basicPluginSetting.getOutputNum()), (FeedContext)feedContext, rss2);
        });
    }

    @Override
    public Mono<ServerResponse> categoryFeed(ServerRequest request, String category) {
        return this.getFeedContext(request).filter(feedContext -> BooleanUtils.isTrue((Boolean)feedContext.basicPluginSetting.getEnableCategories())).flatMap(feedContext -> {
            RSS2 rss2 = this.buildBaseRss((FeedContext)feedContext);
            return this.rssSourceFinder.getCategoriesContentBySlug(category).next().map(categoryContent -> {
                String permalink = categoryContent.getStatusOrDefault().getPermalink();
                if (permalink != null) {
                    URI permalinkUri = URI.create(permalink);
                    if (!permalinkUri.isAbsolute()) {
                        permalinkUri = request.exchange().getRequest().getURI().resolve(permalinkUri);
                    }
                    permalink = permalinkUri.toString();
                }
                rss2.setTitle("\u5206\u7c7b\uff1a" + categoryContent.getSpec().getDisplayName() + " - " + rss2.getTitle());
                rss2.setLink(permalink);
                if (StringUtils.hasText((String)categoryContent.getSpec().getDescription())) {
                    rss2.setDescription(categoryContent.getSpec().getDescription());
                }
                return categoryContent.getMetadata().getName();
            }).flatMap(categoryMetadataName -> {
                Mono<ListResult<Post>> listResultMono = this.rssSourceFinder.listPostsByCategory(1, feedContext.basicPluginSetting.getOutputNum(), (String)categoryMetadataName);
                return this.postListResultToXmlServerResponse(listResultMono, (FeedContext)feedContext, rss2);
            });
        }).onErrorResume(error -> {
            log.error("Failed to get category feed", error);
            return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }).switchIfEmpty(ServerResponse.notFound().build());
    }

    @Override
    public Mono<ServerResponse> authorFeed(ServerRequest request, String author) {
        return this.getFeedContext(request).filter(feedContext -> BooleanUtils.isTrue((Boolean)feedContext.basicPluginSetting.getEnableAuthors())).flatMap(feedContext -> {
            RSS2 rss2 = this.buildBaseRss((FeedContext)feedContext);
            return this.rssSourceFinder.getUserByName(author).flatMap(user -> {
                rss2.setTitle("\u4f5c\u8005\uff1a" + user.getSpec().getDisplayName() + " - " + rss2.getTitle());
                return this.postListResultToXmlServerResponse(this.rssSourceFinder.listPostsByAuthor(1, feedContext.basicPluginSetting.getOutputNum(), author), (FeedContext)feedContext, rss2);
            });
        }).onErrorResume(error -> {
            log.error("Failed to get author feed", error);
            return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }).switchIfEmpty(ServerResponse.notFound().build());
    }

    private Mono<FeedContext> getFeedContext(ServerRequest request) {
        return Mono.zip((Mono)this.settingFetcher.fetch("plugin-rss-config", "basic-config", BasicConfig.class).switchIfEmpty(Mono.just((Object)new BasicConfig())), (Mono)this.settingFetcher.fetch("plugin-rss-config", "rss-config", RssConfig.class).switchIfEmpty(Mono.just((Object)new RssConfig())), this.settingFetcher.fetch("system", "basic", SystemSetting.Basic.class), (Mono)this.settingFetcher.fetch("plugin-rss-config", "follow-config", FollowConfig.class).switchIfEmpty(Mono.just((Object)new FollowConfig()))).map(tuple -> {
            BasicConfig basicPluginSetting = (BasicConfig)tuple.getT1();
            RssConfig rssPluginSetting = (RssConfig)tuple.getT2();
            SystemSetting.Basic systemBasicSetting = (SystemSetting.Basic)tuple.getT3();
            FollowConfig followPluginConfig = (FollowConfig)tuple.getT4();
            Assert.notNull((Object)basicPluginSetting.getOutputNum(), (String)"outputNum cannot be null");
            Assert.isTrue((basicPluginSetting.getOutputNum() > 0 ? 1 : 0) != 0, (String)"OutputNum must be greater than zero");
            Assert.notNull((Object)((Object)basicPluginSetting.getDescriptionType()), (String)"descriptionType cannot be null");
            URL externalUrl = this.externalUrlSupplier.getRaw();
            if (externalUrl == null) {
                externalUrl = this.externalUrlSupplier.getURL((HttpRequest)request.exchange().getRequest());
            }
            return new FeedContext(basicPluginSetting, rssPluginSetting, systemBasicSetting, followPluginConfig, externalUrl);
        });
    }

    private Mono<ServerResponse> postListResultToXmlServerResponse(Mono<ListResult<Post>> postListResult, FeedContext feedContext, RSS2 rss2) {
        return postListResult.flatMapIterable(ListResult::getItems).publishOn(Schedulers.boundedElastic()).publishOn(Schedulers.boundedElastic()).publishOn(Schedulers.boundedElastic()).concatMap(post -> {
            String cover;
            String permalink = post.getStatusOrDefault().getPermalink();
            if (permalink != null) {
                URI permalinkUri = URI.create(permalink);
                if (!permalinkUri.isAbsolute()) {
                    try {
                        permalinkUri = feedContext.externalUrl.toURI().resolve(permalinkUri);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                permalink = permalinkUri.toString();
            }
            RSS2.Item.ItemBuilder itemBuilder = RSS2.Item.builder().title(post.getSpec().getTitle()).link(permalink).author(post.getSpec().getOwner()).pubDate(post.getSpec().getPublishTime()).guid(post.getStatusOrDefault().getPermalink());
            String logo = rss2.getLogo();
            if (logo != null) {
                URI logoUri = URI.create(logo);
                if (!logoUri.isAbsolute()) {
                    try {
                        logoUri = feedContext.externalUrl.toURI().resolve(logoUri);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                logo = logoUri.toString();
                rss2.setLogo(logo);
            }
            if ((cover = post.getSpec().getCover()) != null) {
                URI coverUri = URI.create(cover);
                if (!coverUri.isAbsolute()) {
                    try {
                        coverUri = feedContext.externalUrl.toURI().resolve(coverUri);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                cover = coverUri.toString();
            }
            Object coverImageTag = cover != null && !cover.isEmpty() ? "<img src=\"" + StringEscapeUtils.escapeXml10(cover) + "\" alt=\"\u5c01\u9762\u56fe\u7247\" style=\"max-width:100%; height:auto;\" /><br/>" : "";
            List categories = post.getSpec().getCategories();
            if (categories != null && !categories.isEmpty()) {
                ArrayList<String> categoriesList = new ArrayList<String>();
                for (String category : categories) {
                    this.rssSourceFinder.getCategoryNameById(category).doOnNext(categoriesList::add).subscribe();
                }
                itemBuilder.categories(categoriesList);
            }
            if (Objects.equals((Object)feedContext.basicPluginSetting.getDescriptionType(), (Object)BasicConfig.DescriptionType.content)) {
                String releaseSnapshot = post.getSpec().getReleaseSnapshot();
                String baseSnapshot = post.getSpec().getBaseSnapshot();
                return this.rssSourceFinder.getPostContent(releaseSnapshot, baseSnapshot).map(arg_0 -> RssServiceImpl.lambda$postListResultToXmlServerResponse$11((String)coverImageTag, itemBuilder, arg_0));
            }
            String excerpt = StringEscapeUtils.escapeXml10(post.getStatusOrDefault().getExcerpt());
            String description = (String)coverImageTag + excerpt;
            return Mono.just((Object)itemBuilder.description(description).build());
        }).collectList().map(items -> {
            rss2.setItems((List<RSS2.Item>)items);
            return rss2.toXmlString();
        }).flatMap(xml -> ServerResponse.ok().contentType(MediaType.TEXT_XML).bodyValue(xml));
    }

    private RSS2 buildBaseRss(FeedContext feedContext) {
        return RSS2.builder().title(feedContext.systemBasicSetting.getTitle()).description(StringUtils.hasText((String)feedContext.systemBasicSetting.getSubtitle()) ? feedContext.systemBasicSetting.getSubtitle() : feedContext.systemBasicSetting.getTitle()).link(feedContext.externalUrl.toString()).logo(feedContext.systemBasicSetting.getLogo()).language(feedContext.rssPluginSetting.getLanguage()).ttl(feedContext.rssPluginSetting.getTtl()).webMaster(feedContext.rssPluginSetting.getWebMaster()).copyright(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)feedContext.rssPluginSetting.getCopyright()) ? feedContext.rssPluginSetting.getCopyright() : feedContext.systemBasicSetting.getTitle()).follow(RSS2.Follow.builder().feedId(feedContext.followPluginConfig.getFeedId()).userId(feedContext.followPluginConfig.getUserId()).build()).build();
    }

    public RssServiceImpl(ReactiveSettingFetcherUtils settingFetcher, ExternalUrlSupplier externalUrlSupplier, RssSourceFinder rssSourceFinder) {
        this.settingFetcher = settingFetcher;
        this.externalUrlSupplier = externalUrlSupplier;
        this.rssSourceFinder = rssSourceFinder;
    }

    private static /* synthetic */ RSS2.Item lambda$postListResultToXmlServerResponse$11(String coverImageTag, RSS2.Item.ItemBuilder itemBuilder, ContentWrapper contentWrapper) {
        String content = XmlCharUtils.removeInvalidXmlChar(contentWrapper.getContent());
        String description = coverImageTag + content;
        return itemBuilder.description(description).build();
    }

    record FeedContext(BasicConfig basicPluginSetting, RssConfig rssPluginSetting, SystemSetting.Basic systemBasicSetting, FollowConfig followPluginConfig, URL externalUrl) {
    }
}

