/*
 * Decompiled with CFR 0.152.
 */
package com.ms.studio.service.impl;

import com.ms.studio.models.ContentWrapper;
import com.ms.studio.service.RssSourceFinder;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.comparator.Comparators;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import run.halo.app.core.extension.User;
import run.halo.app.core.extension.content.Category;
import run.halo.app.core.extension.content.Post;
import run.halo.app.core.extension.content.Snapshot;
import run.halo.app.extension.AbstractExtension;
import run.halo.app.extension.ListResult;
import run.halo.app.extension.MetadataUtil;
import run.halo.app.extension.ReactiveExtensionClient;

@Component
public class RssSourceFinderImpl
implements RssSourceFinder {
    public static final Predicate<Post> FIXED_PREDICATE = post -> post.isPublished() && Objects.equals(false, post.getSpec().getDeleted()) && Post.VisibleEnum.PUBLIC.equals((Object)post.getSpec().getVisible()) && post.getMetadata().getDeletionTimestamp() == null;
    private final ReactiveExtensionClient client;

    static Comparator<Post> defaultComparator() {
        Function<Post, Instant> publishTime = post -> post.getSpec().getPublishTime();
        Function<Post, String> name = post -> post.getMetadata().getName();
        return Comparator.comparing(publishTime, Comparators.nullsLow()).thenComparing(name).reversed();
    }

    @Override
    public Mono<ListResult<Post>> listPosts(Integer page, Integer size) {
        return this.listPost(page, size, null, RssSourceFinderImpl.defaultComparator());
    }

    @Override
    public Mono<String> getCategoryNameById(String categoryName) {
        return this.client.get(Category.class, categoryName).flatMap(category -> {
            if (category != null) {
                return Mono.just((Object)category.getSpec().getDisplayName());
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ListResult<Post>> listPostsByCategory(Integer page, Integer size, String category) {
        return this.listPost(page, size, post -> this.contains(post.getSpec().getCategories(), category), RssSourceFinderImpl.defaultComparator());
    }

    @Override
    public Mono<ListResult<Post>> listPostsByAuthor(Integer page, Integer size, String author) {
        return this.listPost(page, size, post -> post.getSpec().getOwner().equals(author), RssSourceFinderImpl.defaultComparator());
    }

    private boolean contains(List<String> c, String key) {
        if (StringUtils.isBlank((CharSequence)key) || c == null) {
            return false;
        }
        return c.contains(key);
    }

    private Mono<ListResult<Post>> listPost(Integer page, Integer size, Predicate<Post> postPredicate, Comparator<Post> comparator) {
        Predicate<Post> predicate = FIXED_PREDICATE.and(postPredicate == null ? post -> true : postPredicate);
        return this.client.list(Post.class, predicate, comparator, page.intValue(), size.intValue());
    }

    @Override
    public Mono<ContentWrapper> getPostContent(String snapshotName, String baseSnapshotName) {
        return this.client.fetch(Snapshot.class, baseSnapshotName).doOnNext(this::checkBaseSnapshot).flatMap(baseSnapshot -> {
            if (StringUtils.equals((CharSequence)snapshotName, (CharSequence)baseSnapshotName)) {
                ContentWrapper wrapper = ContentWrapper.patchSnapshot(baseSnapshot, baseSnapshot);
                return Mono.just((Object)wrapper);
            }
            return this.client.fetch(Snapshot.class, snapshotName).map(snapshot -> ContentWrapper.patchSnapshot(snapshot, baseSnapshot));
        });
    }

    private void checkBaseSnapshot(Snapshot snapshot) {
        Assert.notNull((Object)snapshot, (String)"The snapshot must not be null.");
        String keepRawAnno = (String)MetadataUtil.nullSafeAnnotations((AbstractExtension)snapshot).get("content.halo.run/keep-raw");
        if (!StringUtils.equals((CharSequence)Boolean.TRUE.toString(), (CharSequence)keepRawAnno)) {
            throw new IllegalArgumentException(String.format("The snapshot [%s] is not a base snapshot.", snapshot.getMetadata().getName()));
        }
    }

    @Override
    public Flux<Category> getCategoriesContentBySlug(String slug) {
        return this.client.list(Category.class, category -> StringUtils.equals((CharSequence)category.getSpec().getSlug(), (CharSequence)slug), Comparator.naturalOrder());
    }

    @Override
    public Mono<User> getUserByName(String name) {
        return this.client.fetch(User.class, name);
    }

    public RssSourceFinderImpl(ReactiveExtensionClient client) {
        this.client = client;
    }
}

