/*
 * Decompiled with CFR 0.152.
 */
package com.ms.studio.utils;

import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import run.halo.app.extension.ConfigMap;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.infra.utils.JsonUtils;

@Component
public class ReactiveSettingFetcherUtils {
    private final ReactiveExtensionClient extensionClient;

    public <T> Mono<T> fetch(String configMapName, String group, Class<T> clazz) {
        return this.getValuesInternal(configMapName).filter(map -> map.containsKey(group)).map(map -> (String)map.get(group)).mapNotNull(stringValue -> JsonUtils.jsonToObject((String)stringValue, (Class)clazz));
    }

    @NonNull
    private Mono<Map<String, String>> getValuesInternal(String configMapName) {
        return this.getConfigMap(configMapName).filter(configMap -> configMap.getData() != null).map(ConfigMap::getData).defaultIfEmpty(Map.of());
    }

    private Mono<ConfigMap> getConfigMap(String configMapName) {
        return this.extensionClient.fetch(ConfigMap.class, configMapName);
    }

    public ReactiveSettingFetcherUtils(ReactiveExtensionClient extensionClient) {
        this.extensionClient = extensionClient;
    }
}

